/******************************************************************************
 CAdaApp.h

			Header File For CAdaApp Application Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 9:22 PM Thu, Aug 5, 1993

	This file is only generated once. You can modify it by redefining
	in the placeholder definitions and adding any new methods and
	data members you wish.

	If you change the name of the application, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#pragma once

#include "x_CAdaApp.h"

#include <CDialog.h>
#include "CFind.h"

CLASS CLibrary;
CLASS CFind;
CLASS CEditText;
CLASS CBkgndTask;
CLASS CWindow;			// for memory display

CLASS CSourceDocument;
CLASS CTextDocument;

// Other File items - This is the data type used to store
// references to the files that have been opened recently.
#ifdef __cplusplus
struct OFItem {
#else
typedef struct {
#endif
	SFReply	file;
	long	cmd;
#ifdef __cplusplus
};
#else
} OFItem;
#endif

typedef struct {
		Boolean		exOptSource;
		Boolean		exOptRoutines;
		Boolean		exOptException;
		Boolean		exOptRendezvous;
		Boolean		exOptTask;

		Boolean		exRoundRobin;
		short		exQuantumSize;
} ExOptions;

// Tokens for openListing flag (and the Set/Get routines)
#define openListingAlways true
#define openListingOnError false

class CAdaApp : public x_CAdaApp
{
	// Constants defined in the context of this class
#define	kNumFiles	6

// Data that will be saved in Prefs file

	// Internal Use - not available to the outside
	private:
		// This should be FSSpec, but it requires too many
		// conversions to and from SFReply.
		short		OFCount;
		OFItem		OFList[kNumFiles];


	// This can be queried - Never modify these directly
	protected:
	
		// Find data
		//	struct CFindData		*findData;
		Str255		sSearchString;
		Str255		sReplaceString;
		
		Boolean		sFromBeginning;	
			// t=from beginning, f=from curr location

		Boolean		sLiteralSearch;
			// t=literal search, f=grep search

		// Compile Options
		Boolean		openListing;		// from Options dialogue

		// Execute Options
		ExOptions	executeOptions;

// end of saved data in Prefs


// State Information at Run Time

		Boolean		rProcessing;
		Boolean 	rHasOpenedDocuments;

		CBkgndTask	*backgroundTask;
		CLibrary	*winLibrary;
		CFind		*dlgFind;
		CWindow		*memDisplay;

	protected:
	
		// These routines are used within this class,
		// and I can't think of why anyone else would
		// need them.
		
			void	AddFile2OF(SFReply *macReply);
			Boolean	IsFileInOF(SFReply *macReply);

	public:
			void	ICAdaApp(void);
	virtual	void 	ForceClassReferences(void);

			void	SetUpMenus(void);
			void	CreateDocument( void);
			void	OpenDocument(SFReply *macReply);
			Boolean FsAlreadyOpen(SFReply *macReply);

	virtual	void	UpdateMenus(void);
	virtual	void 	DoCommand(long theCommand);


	// Library Management
	virtual void	DoCmdOpenLibrary(void);
	virtual void	DoCmdNewLibrary(void);
	virtual void	LibraryClosed(void);
			Boolean	SelectLibrary(FSSpec *spec);
			CLibrary	*GetUserLibrary(void);

	// Compiling
			void	Compile(CSourceDocument *document);
			void	Bind(Str255 mainProgram);
			void	Execute(Str255 bindingUnit);

			void	Dawdle(long *maxSleep);

	// Background Feedback
			void	StartingBkgnd(void);
			void	FinishedBkgnd(short alertId, Boolean noteAlert);
			void	Resume( void);

	// Search Management
			void	SetSearchString(Str255 s);
			void	SetSearchOptions(Str255 s, Str255 r,
						Boolean startFrom, Boolean searchType);
	
			void	GetSearchOptions(Str255 *s, Str255 *r,
						Boolean *startFrom, Boolean *searchType);

			Boolean	Search(CTextDocument *doc, long searchCmd);
					// Search in this textEdit field,  move the
					// insertion point and scroll if needed
	
			Boolean	Replace(CTextDocument *doc, long replaceCmd);
					// replace command using current selection 
					// and sReplaceString
	
	// Compile Options Dialogue
			void	SetOptions(Boolean  showLis);
			void	GetOptions(Boolean *showLis);

	// Execute Options Dialogue
			void	SetExOptions(ExOptions options);
			void	GetExOptions(ExOptions *options);

	// General command management
			Boolean	CanCmd(long command);

			// Remove this function if you do not have
			// multiple document types

	virtual	OSType 	GetDocTypeFromDialog(CDialogDirector *dialog);
};

//	File Types
//
//	Change the #defines below to reflect the file types
//	your application actually creates or opens

#define	kNumFileTypes	1
#define	kFileType1		'TEXT'

#define kTextSource		'TEXT'
#define kListingType	'TEXT'
